<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'status', 'type');
    protected $visible = array('name', 'email', 'password', 'status', 'type');

    public function supportTickets()
    {
        return $this->hasMany('App\Models\SupportTicket');
    }

    public function reservations()
    {
        return $this->hasMany('App\Models\Ticket');
    }

    public function rates()
    {
        return $this->hasMany('App\Models\Rate');
    }

}